Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename bash-match
%global enable_tests 1

Name:		nodejs-bash-match
Version:	1.0.2
Release:	alt1_6
Summary:	Match strings using bash, does not work on windows

License:	MIT
URL:		https://github.com/jonschlinkert/bash-match
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/jonschlinkert/%{packagename}/%{version}/test.js

BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(cross-spawn)
BuildRequires:	npm(extend-shallow)
BuildRequires:	npm(is-extglob)
BuildRequires:	npm(is-windows)
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif
Source44: import.info

%description
Match strings using bash. Does not work on windows, and does not read from the
file system. This library requires that Bash 4.3 or higher is installed and is
mostly used for checking parity in unit tests.


%prep
%setup -q -n package

# setup the tests
cp -p %{SOURCE1} .

%nodejs_fixdep cross-spawn

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
