Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
BuildRequires: gcc-c++
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename bcrypt
%global enable_tests 1

Name:		nodejs-bcrypt
Version:	0.8.7
Release:	alt1_14
Summary:	A bcrypt library for NodeJS

License:	MIT
URL:		https://github.com/ncb000gt/node.bcrypt.js
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz


%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm}
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	node-gyp
BuildRequires:	node-devel rpm-build-nodejs
BuildRequires:	npm(bindings)
BuildRequires:	npm(nan)

%if 0%{?enable_tests}
BuildRequires:	npm(nodeunit)
%endif
Source44: import.info

%description
A bcrypt library for NodeJS.


%prep
%setup -q -n package

%nodejs_fixdep bindings "^1.2.1"
%nodejs_fixdep --dev --move nan

%build
%nodejs_symlink_deps --build

node-gyp rebuild
rm -rf node_modules

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js build/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/nodeunit test
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md examples/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
