Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename brace-expansion
%global enable_tests 1

Name:		nodejs-brace-expansion
Version:	1.1.11
Release:	alt1_5
Summary:	Brace expansion as known from sh/bash

License:	MIT
# License text is at the bottom of README.md
URL:		https://github.com/juliangruber/brace-expansion.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	grep
%if 0%{?enable_tests}
BuildRequires:	npm(balanced-match)
BuildRequires:	npm(concat-map)
BuildRequires:	npm(tape)
%endif
Source44: import.info

%description
Brace expansion as known from sh/bash


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package

# Create separate license file from the license information at the bottom of
# the README.md file
grep -A100 '^## License$' README.md > LICENSE.md


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%{_bindir}/tape test/*.js
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE.md
%{nodejs_sitelib}/%{packagename}



%changelog
