Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global npmname bufferutil

Name:           nodejs-%{npmname}
Version:        4.0.1
Release:        alt3_3
Summary:        WebSocket buffer utils

License:        MIT
URL:            https://www.npmjs.com/package/%{npmname}

# Pull sources from github, not npm, in order to include unit tests.
Source0:	https://github.com/websockets/%{npmname}/archive/v%{version}/%{name}-%{version}.tar.gz
# Revert to using bindings instead of prebuildify
Patch0:         nodejs-bufferutil-bindings.patch        

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  node-gyp, nodejs-bindings

BuildRequires:  nodejs-nan

# For unit tests.
BuildRequires:  node-mocha
Source44: import.info


%description
bufferutil provides some utilities to efficiently perform
some operations such as masking and unmasking the data
payload of WebSocket frames.

%prep
%setup -q -n %{npmname}-%{version}
%patch0 -p1



%build
%nodejs_symlink_deps --build
export CXXFLAGS="%{optflags}"
export LDFLAGS="%{?__global_ldflags} -Wl,-z,undefs"
node-gyp rebuild


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/bufferutil/build
cp -p package.json fallback.js index.js %{buildroot}%{nodejs_sitelib}/bufferutil/
cp -p build/Release/bufferutil.node %{buildroot}%{nodejs_sitelib}/bufferutil/build/
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
mocha ./test.js


%files
%{nodejs_sitelib}/%{npmname}/
%doc --no-dereference LICENSE
%doc README.md


%changelog
