Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 32
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename bundle-dependencies
%global enable_tests 1

Name:		nodejs-bundle-dependencies
Version:	1.0.2
Release:	alt1_11
Summary:	Generates bundledDependencies package.json value

License:	BSD
URL:		https://github.com/gajus/bundle-dependencies
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
Patch0:		nodejs-bundle-dependencies_fix-package-json.patch

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
Source44: import.info

%description
Generates bundledDependencies package.json value using values of the
dependencies property.


%prep
%setup -q -n package
rm -rf node_modules
%patch0 -p1

%nodejs_fixdep yargs


# fix she-bang line and make executable
sed -i '1!b;s/env node/node/' dist/bin/index.js
chmod +x dist/bin/index.js

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json dist/ %{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%if 0%{?enable_tests}
echo -e "\e[103m -=#=- There are no tests -=#=- \e[0m"
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
