Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:           nodejs-burrito
Version:        0.2.12
Release:        alt1_21
Summary:        Wrap up expressions with a trace function while walking the AST

#no license file included, "BSD" indicated in package.json
License:        BSD
URL:            https://github.com/substack/node-burrito
Source0:        https://registry.npmjs.org/burrito/-/burrito-%{version}.tgz
#to satisfy the BSD requirement that the text of the license be included, we
#include this copy of the 3-clause BSD as used in one of the author's projects.
Source1:        https://raw.github.com/substack/lambdascape/master/LICENSE

BuildArch:      noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(tap)
%endif
Source44: import.info

%description
Burrito makes it easy to do crazy stuff with the JavaScript AST.

This is useful if you want to roll your own stack traces or build a code
coverage tool.


%prep
%setup -q -n package

%nodejs_fixdep uglify-js '~1.3.4'
%nodejs_fixdep traverse '~0.6.3'

cp -p %{SOURCE1} LICENSE


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/burrito
cp -pr package.json index.js %{buildroot}%{nodejs_sitelib}/burrito

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%tap test/*.js
%endif


%files
%{nodejs_sitelib}/burrito
%doc README.markdown example
%doc --no-dereference  LICENSE


%changelog
