Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-collections
Version:    1.2.4
Release:    alt1_8
Summary:    Data structures with idiomatic JavaScript collection interfaces
# shim-array.js and shim-object.js are forked from Motorola Mobility's Montage,
# which is licensed under the 3-Clause BSD License.
License:    MIT and BSD
URL:        https://github.com/montagejs/collections
Source0:    http://registry.npmjs.org/collections/-/collections-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# revision control repository.
Source1:    spec-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(jasmine-node)
BuildRequires:  npm(weak-map)
%endif
Source44: import.info

%description
This package contains JavaScript implementations of common data structures
with idiomatic interfaces, including extensions for Array and Object.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package

%nodejs_fixdep weak-map '~1.0'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/collections
cp -pr package.json *.js listen/ \
    %{buildroot}%{nodejs_sitelib}/collections

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%if 0%{?enable_tests}
%{nodejs_sitelib}/jasmine-node/bin/jasmine-node spec
%endif


%files
%{!?_licensedir:%global license %doc}
%doc README.md CHANGES.md FUTURE.md
%doc --no-dereference LICENSE.md
%{nodejs_sitelib}/collections


%changelog
