Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-connect-timeout
Version:    1.0.0
Release:    alt1_11
Summary:    Timeout middleware for Node.js and Connect
License:    MIT
URL:        https://github.com/expressjs/timeout
Source0:    http://registry.npmjs.org/connect-timeout/-/connect-timeout-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  mocha node-mocha
BuildRequires:  npm(connect)
BuildRequires:  npm(debug)
BuildRequires:  npm(should)
BuildRequires:  npm(supertest)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/connect-timeout
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/connect-timeout

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
NODE_ENV=test /usr/bin/mocha --require should -R spec
%endif


%files
%doc README.md
%{nodejs_sitelib}/connect-timeout


%changelog
