Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-cookie
Version:    0.3.1
Release:    alt1_6
Summary:    Cookie parsing and serialization for Node.js
License:    MIT
URL:        https://github.com/shtylman/node-cookie
Source0:    http://registry.npmjs.org/cookie/-/cookie-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh


BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
%endif
Source44: import.info

%description
This Node.js module is a basic cookie parser and serializer. It doesn't
make assumptions about how you are going to deal with your cookies. It
basically just provides a way to read and write the HTTP cookie headers.

See RFC6265 for details about the HTTP header for cookies.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/cookie
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/cookie

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/cookie


%changelog
