Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename core-js
%global enable_tests 1

Name:		nodejs-core-js
Version:	2.4.1
Release:	alt1_8
Summary:	Standard library

License:	MIT
URL:		https://github.com/zloirock/core-js.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	npm(promises-aplus-tests)
%endif
Source44: import.info

%description
Standard library


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package

# remove zero length files
find library/modules -type f -delete
find modules/library -type f -delete


%build
# nothing to do!
cp -pr es5/ es6/ es7/ stage/ web/ core/ fn/ index.js shim.js library/
cp -pr modules/*.js library/modules/

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js shim.js client/ library/ modules/ web/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/promises-aplus-tests tests/promises-aplus/adapter
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"

%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}


%changelog
