Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename coveralls
%global enable_tests 0
# tests disabled due to failing git tests, despite the patch to fix some of them

Name:		nodejs-coveralls
Version:	2.11.6
Release:	alt1_7
Summary:	Takes json-cov output into stdin and POSTs to coveralls.io

License:	BSD
URL:		https://github.com/nickmerwin/node-coveralls.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz

# Add a patch to fix syntax of the 'should' module.  It has changed from
# should.be.a.("string") to should.be.a.String()
Patch0:		coveralls-2.11.4-fix-should-syntax.patch


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(js-yaml)
BuildRequires:	npm(minimist)
BuildRequires:	npm(lcov-parse)
BuildRequires:	npm(log-driver)
BuildRequires:	npm(request)
%if 0%{?enable_tests}
BuildRequires:	mocha
BuildRequires:	npm(sinon-restore)
%endif

Requires:	node
Source44: import.info

%description
takes json-cov output into stdin and POSTs to coveralls.io


%prep
%setup -q -n package
%patch0 -p1

%nodejs_fixdep js-yaml
%nodejs_fixdep lcov-parse '~0.0.6'
%nodejs_fixdep log-driver '~1.2.4'
%nodejs_fixdep request '^2.40.0'

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js fixtures/ lib/ test/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}/bin
install -p -D -m0755 bin/coveralls.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}/bin/coveralls.js

mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/%{packagename}/bin/coveralls.js \
    %{buildroot}%{_bindir}/coveralls


%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
/usr/bin/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%{nodejs_sitelib}/%{packagename}
%{_bindir}/coveralls



%changelog
