Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename csrf
%global enable_tests 1

Name:		nodejs-csrf
Version:	3.0.6
Release:	alt1_7
Summary:	Primary logic behind csrf tokens

License:	MIT
URL:		https://github.com/pillarjs/csrf
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(rndm)
BuildRequires:  npm(tsscmp)
BuildRequires:	npm(uid-safe)

%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(base64-url)
BuildRequires:	npm(bluebird)
BuildRequires:	npm(tap)
%endif
Source44: import.info

%description
Primary logic behind csrf tokens


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package

%nodejs_fixdep rndm '^1.1.0'
%nodejs_fixdep uid-safe '^2.1.4'


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec --trace-deprecation --bail --check-leaks test/
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}



%changelog
