Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
BuildRequires: perl(IO/File.pm) perl(strict.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global commit 3aae5f7aa45906cfcb283817cfb6fcb15360391d
%global shortcommit %(c=%{commit}; echo ${c:0:7})

Name:           nodejs-ctype
Version:        0.5.3
Release:        alt1_15
Summary:        Read and write binary structures and data types with Node.js
BuildArch:      noarch

License:        MIT
URL:            https://github.com/rmustacc/node-ctype
Source0:        https://registry.npmjs.org/ctype/-/ctype-%{version}.tgz
#grab the tests from github
Source1:        https://github.com/rmustacc/node-ctype/archive/%{commit}/%{name}-%{version}-%{shortcommit}.tar.gz

# fedora-specific patch to have README indicate proper directions for reading
# the man page from the system path
Patch1:         nodejs-ctype-README.patch

BuildRequires:  rpm-build-nodejs node-devel
Source44: import.info

%description
Node-CType is a way to read and write binary data in a structured and easy to 
use format. Its name comes from the C header file.

There are two APIs that you can use, depending on what abstraction you'd like.
The low level API lets you read and write individual integers and floats from
buffers. The higher level API lets you read and write structures of these.

%prep
%setup -q -n package -a1
%patch1 -p1

#move tests into regular directory
mv node-ctype-%{commit}/tst .
rm -rf node-ctype-%{commit}

%build
#nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/ctype
cp -pr package.json ctf.js ctio.js ctype.js %{buildroot}%{nodejs_sitelib}/ctype

mkdir -p %{buildroot}%{_mandir}/man3
cp -pr man/man3ctype/ctio.3ctype %{buildroot}%{_mandir}/man3/ctio.3

%nodejs_symlink_deps

%check
pushd tst
for dir in ctf ctio/* ctype; do
    pushd $dir
    for f in *.js; do
        %{__nodejs} $f
    done
    popd
done
popd

%files
%{nodejs_sitelib}/ctype
%{_mandir}/man3/ctio.3*
%doc CHANGELOG README README.old
%doc --no-dereference LICENSE

%changelog
