Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename defence
%global enable_tests 1

Name:		nodejs-defence
Version:	1.0.5
Release:	alt1_7
Summary:	Extract fenced code from CommonMark documents

License:	MIT
URL:		https://github.com/kemitchell/defence.js.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:        tests-%{version}.tar.bz2
Source10:       dl-tests.sh
# We also need test.js
Source11:	https://raw.githubusercontent.com/kemitchell/defence.js/v%{version}/test.js

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(commonmark)
%if 0%{?enable_tests}
BuildRequires:	npm(glob)
BuildRequires:	npm(tape)
%endif
Source44: import.info

%description
Extract fenced code from CommonMark documents


%prep
%setup -q -n package
# Setup the test files
%setup -q -T -D -a 1 -n package
cp -p %{SOURCE11} .
%nodejs_fixdep commonmark "^0.24.0"


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/tape test.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}



%changelog
