Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename defence-cli
%global enable_tests 1

Name:		nodejs-defence-cli
Version:	1.0.4
Release:	alt1_10
Summary:	Command-line tool for extracting fenced code from documents

License:	MIT
URL:		https://github.com/kemitchell/defence-cli.js.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The example files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	examples-%{version}.tar.bz2
Source10:	dl-tests.sh

Source20:	LICENSE
# upstream contains no license file


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
#BuildRequires:	
%endif
Source44: import.info

%description
A command-line tool for extracting fenced code from CommonMark documents


%prep
%setup -q -n package
# setup the examples
%setup -q -T -D -a 1 -n package
cp -p %{SOURCE20} .


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json defence usage.txt \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/%{packagename}/defence \
    %{buildroot}%{_bindir}/defence


%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
echo "This module does not contain a test suite..."
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md *.txt examples/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}
%{_bindir}/defence



%changelog
