Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename each
%global enable_tests 0

Name:		nodejs-each
Version:	0.6.1
Release:	alt1_10
Summary:	Chained and parallel async iterator in one elegant function

License:	BSD
URL:		https://github.com/wdavidw/node-each.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	coffee-script

%if 0%{?enable_tests}
BuildRequires:	node-mocha
BuildRequires:	npm(should)
%endif
Source44: import.info

%description
Chained and parallel async iterator in one elegant function


%prep
%setup -q -n package

# remove pre-compiled script
rm lib/*.js

%nodejs_fixdep glob "^6.0.0"


%build
%{_bindir}/coffee -c -b -o lib/ src/

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
NODE_ENV=test %{_bindir}/mocha --compilers coffee:coffee-script/register -R spec
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md samples/ doc/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}



%changelog
