Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename echomd
%global enable_tests 1

Name:		nodejs-echomd
Version:	0.1.2
Release:	alt1_6
Summary:	An md like conversion tool for shell terminals

License:	MIT
URL:		https://github.com/WebReflection/echomd
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
#BuildRequries:	
%endif
Source44: import.info

%description
An md like conversion tool for shell terminals


%prep
%setup -q -n package

# setup the tests
%setup -q -T -D -a 1 -n package


# Fix interpreter
sed -i 's/env node/node/g' js/echomd

# The 0.1.2 tag still had version 0.1.1 in the test, fixed in commit 8a2d342
sed -i s/0.1.1/%{version}/ test/*-echomd

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json js/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
echo -e "\e[102m -=#=- Testing version %{version} -=#=- \e[0m"
%__nodejs js/echomd -h > test/js-echomd
diff test/js-echomd test/demo-echomd || exit 1;
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
