Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


Name:           nodejs-es-abstract
Version:        1.17.3
Release:        alt1_2
Summary:        ECMAScript spec abstract operations

License:        MIT
URL:            https://github.com/ljharb/es-abstract
Source0:        https://github.com/ljharb/es-abstract/archive/v%{version}/%{name}-%{version}.tar.gz
# Patch out use of shims that modern Node.js already provides
Patch0:         nodejs-es-abstract-shims.patch
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(es-to-primitive)
BuildRequires:  npm(foreach)
BuildRequires:  npm(function-bind)
BuildRequires:  npm(is-callable)
BuildRequires:  npm(is-regex)
BuildRequires:  npm(make-arrow-function)
BuildRequires:  npm(object.assign)
BuildRequires:  npm(object-is)
BuildRequires:  npm(tape)
Source44: import.info


%description
ECMAScript spec abstract operations. When different versions of the
spec conflict, the default export will be the latest version of the
abstract operation. All abstract operations will also be available
under an es5/es6/es7 exported property if you require a specific version.


%prep
%setup -q -n es-abstract-%{version}
%patch0 -p1

%nodejs_fixdep object-inspect "^1.6.0"
rm -rf node_modules


%build


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/es-abstract
cp -pr package.json *.js 5 2015 2016 2017 2018 2019 helpers %{buildroot}%{nodejs_sitelib}/es-abstract
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} test/index.js


%files
%doc README.md CHANGELOG.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/es-abstract


%changelog
