Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename es6-shim
# Tests disabled due to missing dependencies
%global enable_tests 0

Name:		nodejs-es6-shim
Version:	0.35.1
Release:	alt1_8
Summary:	ECMAScript 6 (Harmony) compatibility shims for legacy JavaScript engines

License:	MIT
URL:		https://github.com/paulmillr/es6-shim.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(chai)
BuildRequires:	npm(promises-aplus-tests)
BuildRequires:	npm(promises-es6-tests)
%endif
Source44: import.info

%description
ECMAScript 6 (Harmony) compatibility shims for legacy JavaScript engines


%prep
%setup -q -n package


%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json es6-shim.js es6-sham.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec test/*.js test/*/*.js
NODE_ENV=test %{_bindir}/mocha -R spec test-sham/*.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
