Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# json-diff is not yet in Fedora
%global enable_tests 0
%global module_name esprima-fb

Name:           nodejs-%{module_name}
Version:        15001.1.0
Release:        alt1_13
Summary:        Facebook-specific fork of the esprima project

License:        BSD
URL:            https://github.com/facebook/esprima
Source0:        http://registry.npmjs.org/%{module_name}/-/%{module_name}-%{version}-dev-harmony-fb.tgz
Source1:        http://github.com/facebook/esprima/raw/master/LICENSE.BSD
Source2:        https://raw.githubusercontent.com/facebookarchive/esprima/fb-harmony/test/harmonytest.js
Source3:        https://raw.githubusercontent.com/facebookarchive/esprima/fb-harmony/test/fbtest.rec.js
Source4:        https://raw.githubusercontent.com/facebookarchive/esprima/fb-harmony/test/harmonymodulestest.js
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:  npm(json-diff)
%endif
Provides:       npm(esprima-fb) = %{version}
Source44: import.info

%description
Esprima (esprima.org, BSD license) is a high performance, standard-compliant
ECMAScript parser written in ECMAScript (also popularly known as JavaScript).

Esprima-FB is a fork of the Harmony branch of Esprima that implements JSX
specification on top of ECMAScript syntax.

%prep
%setup -q -n package
cp -p %{SOURCE1} .
cp -p %{SOURCE2} test/
cp -p %{SOURCE3} test/
cp -p %{SOURCE4} test/

rm -rf node_modules

%build
# nothing to build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{module_name}
cp -pr package.json *.js bin %{buildroot}%{nodejs_sitelib}/%{module_name}
mkdir -p %{buildroot}%{_bindir}
# We need to rename binaries as they conflict with npm(esprima) binaries
ln -s %{nodejs_sitelib}/%{module_name}/bin/esparse.js %{buildroot}%{_bindir}/esparse-fb.js
ln -s %{nodejs_sitelib}/%{module_name}/bin/esvalidate.js %{buildroot}%{_bindir}/esvalidate-fb.js


%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
node test/run.js
%endif

%files
%doc README.md
%doc --no-dereference LICENSE.BSD
%{_bindir}/esparse-fb.js
%{_bindir}/esvalidate-fb.js
%{nodejs_sitelib}/%{module_name}

%changelog
