Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global enable_tests 0
%global prerelease dev
%global dangler -harmony

Name:               nodejs-esprima-harmony-jscs
Version:            1.1.0
Release:            alt1_0.10.%{prerelease}
Summary:            ECMAScript parsing infrastructure for multipurpose analysis

License:            BSD
URL:                https://www.npmjs.org/package/esprima-harmony-jscs
Source0:            http://registry.npmjs.org/esprima-harmony-jscs/-/esprima-harmony-jscs-%{version}-%{prerelease}%{dangler}.tgz
BuildArch:          noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:      npm(jslint)
BuildRequires:      npm(unicode-6.3.0)
BuildRequires:      npm(istanbul)
BuildRequires:      npm(regenerate)
BuildRequires:      npm(complexity-report)
BuildRequires:      npm(json-diff)
BuildRequires:      npm(eslint)
%endif
Source44: import.info


%description
Esprima is a high performance, standard-compliant ECMAScript parser written in
ECMAScript (also popularly known as JavaScript). Esprima is created and
maintained by Ariya Hidayat with the help of many contributors.

%prep
%setup -q -n package

# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep --caret

%build
# This gives warnings when running the tests.
#%nodejs_symlink_deps --build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/esprima-harmony-jscs/
cp -pr package.json esprima.js bin/ \
    %{buildroot}%{nodejs_sitelib}/esprima-harmony-jscs/

mkdir -p %{buildroot}/%{_bindir}/
ln -s %{nodejs_sitelib}/esprima-harmony-jscs/bin/esparse.js %{buildroot}/%{_bindir}/esparse
ln -s %{nodejs_sitelib}/esprima-harmony-jscs/bin/esvalidate.js %{buildroot}/%{_bindir}/esvalidate

%nodejs_symlink_deps

%check
%if 0%{?enable_tests}
%nodejs_symlink_deps --check
node test/run.js
%endif


%files
%doc README.md
%{nodejs_sitelib}/esprima-harmony-jscs/
%{_bindir}/esparse
%{_bindir}/esvalidate

%changelog
