Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename estraverse-fb
%global enable_tests 1

Name:		nodejs-estraverse-fb
Version:	1.3.1
Release:	alt1_8
Summary:	Drop-in for estraverse that enables traversal over React's JSX nodes

License:	MIT
URL:		https://github.com/RReverser/estraverse-fb
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz

# Patch to fix syntax in tests from XJS to JSX
Patch0:		nodejs-estraverse-fb_fix-tests.patch

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(estraverse)
%if 0%{?enable_tests}
BuildRequires:	npm(chai)
BuildRequires:	npm(esprima-fb)
BuildRequires:	mocha node-mocha
%endif
Source44: import.info

%description
Drop-in for estraverse that enables traversal over React's JSX nodes.


%prep
%setup -q -n package
%patch0 -p1

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}


%changelog
