Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# npm(chai) not available on EL6.
%if 0%{?fedora} || 0%{?rhel} >= 7
%global enable_tests 0
%endif

Name:       nodejs-esutils
Version:    2.0.2
Release:    alt1_6
Summary:    Utility box for ECMAScript language tools
License:    BSD
URL:        https://github.com/Constellation/esutils
Source0:    http://registry.npmjs.org/esutils/-/esutils-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:        tests-%{version}.tar.bz2
Source10:       dl-tests.sh


BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(chai)
BuildRequires:  npm(coffee-script)
BuildRequires:  npm(mocha)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
# setup test files
%setup -q -T -D -a 1 -n package

%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/esutils
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/esutils

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha --compilers coffee:coffee-script/register -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc README.md
%doc --no-dereference LICENSE.BSD
%{nodejs_sitelib}/esutils


%changelog
