Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-eventemitter2
Version:    0.4.13
Release:    alt1_11
Summary:    A Node.js event emitter implementation with namespaces, wildcards and TTL
# License text is in README.md.
License:    MIT
URL:        https://github.com/hij1nx/EventEmitter2
Source0:    http://registry.npmjs.org/eventemitter2/-/eventemitter2-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# revision control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(nodeunit)
%endif
Source44: import.info

%description
A Node.js event emitter implementation with namespaces, wildcards,
time to live (TTL) and browser support.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/eventemitter2
cp -pr package.json index.js lib/ \
    %{buildroot}%{nodejs_sitelib}/eventemitter2

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/nodeunit/bin/nodeunit test/simple/
%{nodejs_sitelib}/nodeunit/bin/nodeunit test/wildcardEvents/
%endif


%files
%doc README.md
%{nodejs_sitelib}/eventemitter2


%changelog
