Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-express
Version:    3.5.2
Release:    alt1_14
Summary:    Sinatra inspired web development framework for Node.js
License:    MIT
URL:        https://github.com/visionmedia/express
Source0:    http://registry.npmjs.org/express/-/express-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source2:    examples-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(buffer-crc32)
BuildRequires:  npm(commander)
BuildRequires:  npm(connect)
BuildRequires:  npm(cookie)
BuildRequires:  npm(cookie-signature)
BuildRequires:  npm(debug)
BuildRequires:  npm(ejs)
BuildRequires:  npm(fresh)
BuildRequires:  npm(jade)
BuildRequires:  npm(marked)
BuildRequires:  npm(merge-descriptors)
BuildRequires:  npm(methods)
BuildRequires:  npm(mkdirp)
BuildRequires:  npm(mocha)
BuildRequires:  npm(range-parser)
BuildRequires:  npm(send)
BuildRequires:  npm(should)
BuildRequires:  npm(stylus)
BuildRequires:  npm(supertest)
%endif
Source44: import.info

%description
This Node.js module is a fast, minimalist web development framework inspired
by Sinatra.

The Express philosophy is to provide small, robust tooling for HTTP servers.
Making it a great solution for single page applications, web sites, hybrids,
or public HTTP APIs.

Built on Connect you can use only what you need, and nothing more,
applications can be as big or as small as you like, even a single file.
Express does not force you to use any specific ORM or template engine. With
support for over 14 template engines via Consolidate.js you can quickly craft
your perfect framework.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
%setup -q -T -D -a 2 -n package

%nodejs_fixdep commander '>=1.3.2'
%nodejs_fixdep range-parser '~1.0.0'
%nodejs_fixdep mkdirp '~0.3'
%nodejs_fixdep cookie '~0.1.2'
%nodejs_fixdep buffer-crc32 '~0.2.1'
%nodejs_fixdep fresh '~0.2.2'
%nodejs_fixdep methods
%nodejs_fixdep send '~0.3.0'
%nodejs_fixdep cookie-signature '~1.0.3'
%nodejs_fixdep merge-descriptors '^1.0.0'
%nodejs_fixdep debug '^2.2.0'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/express
cp -pr package.json index.js lib/ \
    %{buildroot}%{nodejs_sitelib}/express
mkdir -p %{buildroot}%{nodejs_sitelib}/express/bin
install -p -D -m0755 bin/express \
    %{buildroot}%{nodejs_sitelib}/express/bin/express
mkdir -p %{buildroot}%{_bindir}
ln -s %{nodejs_sitelib}/express/bin/express \
    %{buildroot}%{_bindir}/express

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
rm -f test.js
NODE_ENV=test /usr/bin/mocha --reporter dot \
    --globals setImmediate,clearImmediate --check-leaks
NODE_ENV=test %{nodejs_sitelib}/mocha/bin/mocha --reporter dot --bail \
    test/acceptance/*.js
%endif


%files
%doc History.md LICENSE Readme.md examples/
%{nodejs_sitelib}/express
%{_bindir}/express


%changelog
