Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename faucet
%global enable_tests 1

Name:		nodejs-faucet
Version:	0.0.1
Release:	alt1_6
Summary:	Human-readable TAP summarizer

License:	MIT
URL:		https://github.com/substack/faucet.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The example files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	examples-%{version}.tar.bz2
Source10:	dl-tests.sh
# The license file is upstream, but not in the npm tarball.
Source20:	https://raw.githubusercontent.com/substack/faucet/0.0.1/LICENSE


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(tap-parser)
BuildRequires:	npm(through2)
%if 0%{?enable_tests}
BuildRequires:	npm(duplexer)
BuildRequires:	npm(sprintf)
%endif
Source44: import.info

%description
A human-readable TAP summarizer.


%prep
%setup -q -n package
# setup the examples
%setup -q -T -D -a 1 -n package
# copy the LICENSE file
cp -p %{SOURCE20} .

sed -i '1s/env //' bin/cmd.js

%nodejs_fixdep defined
%nodejs_fixdep minimist
%nodejs_fixdep tap-parser
%nodejs_fixdep tape
%nodejs_fixdep through2

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}/bin
install -p -D -m0755 bin/cmd.js %{buildroot}%{nodejs_sitelib}/%{packagename}/bin/cmd.js

mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/%{packagename}/bin/cmd.js \
    %{buildroot}%{_bindir}/faucet


%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
echo -e "\e[102m -=#=- This package has no tests -=#=- \e[0m"
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.markdown example/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}
%{_bindir}/faucet


%changelog
