Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-fileset
Version:    0.2.1
Release:    alt1_11
Summary:    A wrapper around glob and minimatch for Node.js
License:    MIT
URL:        https://github.com/mklabs/node-fileset
Source0:    https://registry.npmjs.org/fileset/-/fileset-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(glob)
%endif
Source44: import.info

%description
This Node.js module exposes a basic wrapper on top of nodejs-glob and
nodejs-minimatch. It adds multiple patterns matching and allows a list
of include patterns and optional exclude patterns.


%prep
%setup -q -n package
%nodejs_fixdep glob
%nodejs_fixdep minimatch


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/fileset
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/fileset

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%__nodejs ./tests/test.js && %__nodejs ./tests/test-sync.js
%endif


%files
%doc README.md CHANGELOG.md
%doc --no-dereference LICENSE-MIT
%{nodejs_sitelib}/fileset


%changelog
