Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-formidable
Version:    1.1.1
Release:    alt1_7
Summary:    A Node.js module for parsing form data, especially file uploads
License:    MIT
URL:        https://github.com/felixge/node-formidable
Source0:    https://github.com/felixge/node-formidable/archive/v%{version}/formidable-%{version}.tar.gz

BuildArch:  noarch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(findit)
BuildRequires:  npm(gently)
BuildRequires:  npm(hashish)
BuildRequires:  npm(urun)
BuildRequires:  npm(utest)
%endif
Source44: import.info

%description
This is a Node.js module for parsing form data, especially file uploads.
It was developed for Transloadit, a service focused on uploading and encoding
images and videos.

It offers:
 - Fast (~500mb/sec), non-buffering multipart parser
 - Automatically writing file uploads to disk
 - Low memory footprint
 - Graceful error handling
 - Very high test coverage


%prep
%setup -q -n node-formidable-%{version}

rm -rf node-gently/


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/formidable
cp -pr package.json index.js lib/ \
    %{buildroot}%{nodejs_sitelib}/formidable

%nodejs_symlink_deps


%check
%{__nodejs} -e 'require("./")'

%if 0%{?enable_tests}
%__nodejs test/run.js
%endif


%files
%doc Readme.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/formidable


%changelog
