Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-gaze
Version:    1.1.3
Release:    alt1_4
Summary:    A globbing fs.watch wrapper built from parts of other watch libraries
License:    MIT
URL:        https://github.com/shama/gaze
Source0:    http://registry.npmjs.org/gaze/-/gaze-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source2:    https://raw.githubusercontent.com/shama/gaze/v%{version}/Gruntfile.js
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(async)
BuildRequires:  npm(globule)
BuildRequires:  npm(grunt)
BuildRequires:  npm(grunt-cli)
BuildRequires:  npm(grunt-contrib-nodeunit)
BuildRequires:  npm(nodeunit)
BuildRequires:  npm(rimraf)
%endif
Source44: import.info

%description
This Node.js module provides a globbing fs.watch wrapper built from the best
parts of other fine watch libraries: speedy data behavior from chokidar, the
API interface from watch, and file globbing using glob.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
cp -p %{SOURCE2} .

%build
#nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/gaze
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/gaze

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
/usr/bin/grunt nodeunit -v
%endif


%files
%doc LICENSE-MIT README.md
%{nodejs_sitelib}/gaze


%changelog
