Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename glob-expand
%global enable_tests 1

Name:		nodejs-glob-expand
Version:	0.2.1
Release:	alt1_7
Summary:	A sync glob / minimatch / RegExp function

License:	MIT
URL:		https://github.com/anodynos/node-glob-expand
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	source-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	coffee-script
BuildRequires:	npm(glob)
BuildRequires:	npm(lodash)

%if 0%{?enable_tests}
# nothing
%endif
Source44: import.info

%description
A sync glob / minimatch / RegExp function with a gruntjs-like *expand* of
patterns, with minimum dependencies. Derived from gruntjs's v0.4.1
file.expand.


%prep
%setup -q -n package

# setup the sources
%setup -q -T -D -a 1 -n package

rm -rf build/code/*.js

%nodejs_fixdep glob
%nodejs_fixdep lodash

%build
%nodejs_symlink_deps --build
# Building with straight coffeescript instead of using uRequire
# but it should work fine
coffee -o build/code/ -bc source/code/*.coffee
rm -rf node_modules

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json build/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
echo -e "\e[101m -=#=- This package has no tests -=#=- \e[0m"
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
