Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global enable_tests 0
%global prerelease 9
%global barename gonzales-pe

Name:               nodejs-gonzales-pe
Version:            3.0.0
Release:            alt1_0.12.%{prerelease}
Summary:            Gonzales Preprocessor Edition (fast CSS parser)

License:            MIT
URL:                https://www.npmjs.org/package/gonzales-pe
Source0:            http://registry.npmjs.org/gonzales-pe/-/gonzales-pe-3.0.0-%{prerelease}.tgz
BuildArch:          noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:      npm(coffee-script)
BuildRequires:      npm(benchmark)
BuildRequires:      npm(microtime)
BuildRequires:      npm(mocha)
%endif
Source44: import.info


%description
Gonzales is a fast CSS parser.
Gonzales PE is a rework with support of preprocessors.

%prep
%setup -q -n package

# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep --caret

%build
%nodejs_symlink_deps --build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/gonzales-pe
cp -pr package.json lib \
    %{buildroot}%{nodejs_sitelib}/gonzales-pe

%nodejs_symlink_deps


%check
%if 0%{?enable_tests}
%nodejs_symlink_deps --check
(mkdir -p log && node ./test/mocha.js) | tee ./log/test.log
%endif


%files
%doc CHANGELOG.md README.md MIT-LICENSE.txt doc/
%{nodejs_sitelib}/gonzales-pe/

%changelog
