Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# Tests are hanging forever on Node.js 6
# Next time this package is rebased, please check to see if upstream has
# fixed this.
%global enable_tests 0

Name:       nodejs-grunt-contrib-watch
Version:    0.6.1
Release:    alt1_14
Summary:    Run predefined tasks whenever watched file patterns are added/changed/deleted
License:    MIT
URL:        https://github.com/gruntjs/grunt-contrib-watch
Source0:    https://registry.npmjs.org/grunt-contrib-watch/-/grunt-contrib-watch-%{version}.tgz
# https://raw.githubusercontent.com/gruntjs/grunt-contrib-watch/c190351f5262fc6b6c6a1479c990adedb18d629d/Gruntfile.js
Source1:    Gruntfile-%{version}.js
# The test files are missing from the NPM tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source2:    tests-v%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(async)
BuildRequires:  npm(gaze)
BuildRequires:  npm(grunt-cli)
BuildRequires:  npm(grunt-contrib-internal)
BuildRequires:  npm(grunt-contrib-nodeunit)
BuildRequires:  npm(lodash)
BuildRequires:  npm(tiny-lr-fork)
BuildRequires:  npm(underscore.string)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%setup -q -T -D -a 2 -n package
cp -p %{SOURCE1} Gruntfile.js
%nodejs_fixdep async ^1.5.0
%nodejs_fixdep lodash ^3.10.1


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/grunt-contrib-watch
cp -pr package.json tasks/ \
    %{buildroot}%{nodejs_sitelib}/grunt-contrib-watch

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
/usr/bin/grunt nodeunit -v
%endif


%files
%doc README.md
%doc --no-dereference LICENSE-MIT
%{nodejs_sitelib}/grunt-contrib-watch


%changelog
