Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global enable_tests 0
%global barename grunt-saucelabs

Name:               nodejs-grunt-saucelabs
Version:            8.6.1
Release:            alt1_11
Summary:            Grunt task running tests using Sauce Labs

License:            MIT
URL:                https://www.npmjs.org/package/grunt-saucelabs
Source0:            http://registry.npmjs.org/%{barename}/-/%{barename}-%{version}.tgz
BuildArch:          noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel

# These are automatically added as Requires
# https://fedoraproject.org/wiki/Packaging:Node.js?rd=Node.js/Packagers#Automatic_Requires_and_Provides
#Requires:           npm(saucelabs)
#Requires:           npm(q)
#Requires:           npm(colors)
#Requires:           npm(lodash)
#Requires:           npm(sauce-tunnel)
#Requires:           npm(grunt)
#Requires:           npm(request)

%if 0%{?enable_tests}
BuildRequires:      npm(saucelabs)
BuildRequires:      npm(q)
BuildRequires:      npm(colors)
BuildRequires:      npm(lodash)
BuildRequires:      npm(sauce-tunnel)
BuildRequires:      npm(grunt)
BuildRequires:      npm(request)
BuildRequires:      npm(grunt-sauce-tunnel)
BuildRequires:      npm(grunt-contrib-watch)
BuildRequires:      npm(grunt-contrib-connect)
BuildRequires:      npm(grunt-contrib-jshint)
BuildRequires:      npm(grunt-jscs-checker)
BuildRequires:      npm(publish)
BuildRequires:      npm(merge)
BuildRequires:      npm(load-grunt-config)
BuildRequires:      npm(grunt)
%endif
Source44: import.info


%description
A Grunt task for running QUnit, Jasmine, Mocha, YUI tests, or any framework
using Sauce Labs' Cloudified Browsers.

%prep
%setup -q -n package

# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep q '>=0.9.6'
%nodejs_fixdep request '>=2.25.0'
%nodejs_fixdep requestretry '1.x'
%nodejs_fixdep lodash '^3.10.1'
%nodejs_fixdep colors

%build
%nodejs_symlink_deps --build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/grunt-saucelabs
cp -pr package.json tasks Gruntfile.js \
    %{buildroot}%{nodejs_sitelib}/grunt-saucelabs

%nodejs_symlink_deps


%check
%if 0%{?enable_tests}
%nodejs_symlink_deps --check
grunt
%endif


%files
%doc LICENSE-MIT README.md
%{nodejs_sitelib}/grunt-saucelabs/

%changelog
