Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global modname grunt-sed

%if ! ( 0%{?fedora} || 0%{?rhel} >= 7 )

%global nodejs_arches %{ix86} x86_64 %{arm}
%endif

# tests are disabled until grunt-exec is packaged
%bcond_with tests

Name:           nodejs-%{modname}
Version:        0.1.1
Release:        alt1_10
Summary:        Grunt task for search and replace
License:        MIT
URL:            https://github.com/jharding/grunt-sed
Source0:        http://registry.npmjs.org/%{modname}/-/%{modname}-%{version}.tgz
BuildArch:      noarch
BuildRequires:  rpm-build-nodejs node-devel
%if %{with tests}
BuildRequires:  npm(replace)
BuildRequires:  npm(grunt-contrib-jshint)
BuildRequires:  npm(grunt-exec)
%endif
Source44: import.info

%description
Built on top of replace, grunt-sed is a Grunt plugin for performing search and 
replace on files.

%prep
%setup -q -n package
%nodejs_fixdep replace

%build
# nothing to do

%check
%if %{with tests}
%nodejs_symlink_deps --check
grunt test
%endif

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{modname}
cp -pr package.json tasks/ %{buildroot}%{nodejs_sitelib}/%{modname}/
%nodejs_symlink_deps

%files
%doc README.md LICENSE-MIT
%{nodejs_sitelib}/%{modname}

%changelog
