Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename grunt-simple-mocha

# Tests disabled because they fail in mock, even if they pass locally
%global enable_tests 0

Name:		nodejs-grunt-simple-mocha
Version:	0.4.1
Release:	alt1_10
Summary:	A simple wrapper for running tests with Mocha

License:	MIT
URL:		https://github.com/yaymukund/grunt-simple-mocha.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# Fix a path in the test file
Patch0:		nodejs-grunt-simple-mocha_fix-tests.patch

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	mocha node-mocha

%if 0%{?enable_tests}
BuildRequires:	npm(grunt)
BuildRequires:	npm(grunt-cli)
BuildRequires:	npm(grunt-contrib-jshint)
%endif
Source44: import.info

%description
A simple wrapper for running tests with Mocha.


%prep
%setup -q -n package
%patch0 -p1


# fix she-bang line in grunt-simple-mocha
sed -i '1!b;s/env node/node/' bin/grunt-simple-mocha

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js bin/ tasks/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
ln -s %{nodejs_sitelib}/grunt-cli node_modules/grunt-cli
%if 0%{?enable_tests}
%{_bindir}/grunt
NODE_ENV=test %{_bindir}/mocha -R spec tests/acceptance-tests.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE-MIT
%{nodejs_sitelib}/%{packagename}

%changelog
