Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename heap
%global enable_tests 1

Name:		nodejs-heap
Version:	0.2.6
Release:	alt1_12
Summary:	Binary heap (priority queue) algorithms

License:	Python
# license text is at bottom of README.md
URL:		https://github.com/qiao/heap.js.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	coffee-script
BuildRequires:	mocha node-mocha
BuildRequires:	npm(should)
%endif
Source44: import.info

%description
Binary heap (priority queue) algorithms (ported from Python's heapq module)


%prep
%setup -q -n package

# remove pre-compiled version
rm lib/heap.js

%build
%{_bindir}/coffee -c -b -o lib/ src/*.coffee

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%{_bindir}/coffee -c -b test/*.coffee
%{_bindir}/mocha -r should -R spec
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%{nodejs_sitelib}/%{packagename}



%changelog
