Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global commit 8881c4a806604deabe958f37e51672a65ef150fe
%global shortcommit %(c=%{commit}; echo ${c:0:7})

Name:           nodejs-http-signature
Version:        0.10.0
Release:        alt1_16
Summary:        Reference implementation of Joyent's HTTP Signature Scheme
BuildArch:      noarch

License:        MIT
URL:            https://github.com/joyent/node-http-signature
Source0:        https://registry.npmjs.org/http-signature/-/http-signature-%{version}.tgz
#grab the tests from github
Source1:        https://github.com/joyent/node-http-signature/archive/%{commit}/%{name}-%{version}-%{shortcommit}.tar.gz

BuildRequires:  rpm-build-nodejs node-devel

#for tests
BuildRequires:  npm(tap)
BuildRequires:  npm(node-uuid)
BuildRequires:  npm(assert-plus)
BuildRequires:  npm(asn1)
BuildRequires:  npm(ctype)
Source44: import.info

%description
nodejs-http-signature is a node.js library that has client and server components 
for Joyent's HTTP Signature Scheme.

%prep
%setup -q -n package -a1

%nodejs_fixdep assert-plus
%nodejs_fixdep ctype '~0.5.3'
%nodejs_fixdep asn1 '~0.1.11'

#move tests into regular directory
mv node-http-signature-%{commit}/test .
rm -rf node-http-signature-%{commit}

%build
#nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/http-signature
cp -pr package.json lib %{buildroot}%{nodejs_sitelib}/http-signature

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%tap test/*.js

%files
%{nodejs_sitelib}/http-signature
%doc README.md http_signing.md
%doc --no-dereference LICENSE

%changelog
