Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename is-fullwidth-code-point
%global enable_tests 0
# tests disabed until 'ava' is packaged for Fedora

Name:		nodejs-is-fullwidth-code-point
Version:	1.0.0
Release:	alt1_9
Summary:	Check if given Unicode code point is fullwidth

License:	MIT
URL:		https://github.com/sindresorhus/is-fullwidth-code-point
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/sindresorhus/is-fullwidth-code-point/v%{version}/test.js


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(number-is-nan)
%if 0%{?enable_tests}
BuildRequires:	npm(ava)
BuildRequires:	npm(code-point-at)
%endif
Source44: import.info

%description
Check if the character represented by a given Unicode code point is fullwidth


%prep
%setup -q -n package
# setup the tests
cp -r %{SOURCE1} .


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{__nodejs} test.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference license
%{nodejs_sitelib}/%{packagename}


%changelog
