Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename is-path-cwd
%global enable_tests 1

Name:		nodejs-is-path-cwd
Version:	1.0.0
Release:	alt1_8
Summary:	Check if a path is CWD

License:	MIT
URL:		https://github.com/sindresorhus/is-path-cwd
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/sindresorhus/is-path-cwd/v%{version}/test.js
# The license file is included in the npm tarball.
Source2:	https://raw.githubusercontent.com/sindresorhus/is-path-cwd/v%{version}/license


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif
Source44: import.info

%description
Check if a path is CWD


%prep
%setup -q -n package
# setup the tests
cp -p %{SOURCE1} .
# setup the license file
cp -p %{SOURCE2} .



%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo "Tests disabled..."
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference license
%{nodejs_sitelib}/%{packagename}


%changelog
