Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename isobject
%global enable_tests 1

Name:		nodejs-isobject
Version:	3.0.1
Release:	alt1_5
Summary:	Returns true if the value is an object and not an array or null

License:	MIT
URL:		https://github.com/jonschlinkert/isobject.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Grab from upstream github repo instead
Source1:	https://raw.githubusercontent.com/jonschlinkert/isobject/%{version}/test.js


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(isarray)
%endif
Source44: import.info

%description
Returns true if the value is an object and not an array or null.


%prep
%setup -q -n package
# setup the tests
cp -p %{SOURCE1} .

%nodejs_fixdep isarray


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo "Tests disabled..."
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}


%changelog
