Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:           nodejs-js-yaml
Version:        3.10.0
Release:        alt1_6
Summary:        YAML 1.2 parser and serializer

License:        MIT
URL:            https://github.com/nodeca/js-yaml
Source0:        https://registry.npmjs.org/js-yaml/-/js-yaml-%{version}.tgz
# The test/ directory is not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# revision control repository.
Source1:        tests-%{version}.tar.bz2
Source2:        examples-%{version}.tar.bz2
Source10:       dl-tests.sh

BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(esprima)
BuildRequires:  npm(mocha)
%endif
Source44: import.info

%description
This is an implementation of YAML (YAML Ain't Markup Language), a human
friendly data serialization language. It started as PyYAML port, and was
completely rewritten from scratch.  Now it's very fast, and supports the
1.2 spec.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
%setup -q -T -D -a 2 -n package

sed -i '1s/env //' bin/js-yaml.js

%nodejs_fixdep esprima


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/js-yaml
cp -pr package.json index.js lib/ \
    %{buildroot}%{nodejs_sitelib}/js-yaml

mkdir -p %{buildroot}%{nodejs_sitelib}/js-yaml/bin
install -p -D -m0755 bin/js-yaml.js \
    %{buildroot}%{nodejs_sitelib}/js-yaml/bin/js-yaml.js
mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/js-yaml/bin/js-yaml.js \
    %{buildroot}%{_bindir}/js-yaml

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%endif


%files
%{!?_licensedir:%global license %doc}
%doc README.md CHANGELOG.md examples/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/js-yaml
%{_bindir}/js-yaml


%changelog
