Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 32
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename JSONSelect
%global enable_tests 1

Name:		nodejs-jsonselect
Version:	0.4.0
Release:	alt1_15
Summary:	CSS-like selectors for JSON

License:	ISC
URL:		https://github.com/lloyd/JSONSelect.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
Source1:	https://raw.githubusercontent.com/lloyd/JSONSelect/master/LICENSE

Patch0:		nodejs-jsonselect_fix-print.patch

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	uglify-js
%endif
Source44: import.info

%description
CSS-like selectors for JSON


%prep
%setup -q -n package
%patch0 -p1
cp -p %{SOURCE1} .

# rename the build directory, so that we can delete most of it
# since in bundles js-hint and uglify-js
mv src/build src/build.disabled
# make a new (clean) build directory
mkdir src/build
# copy over only the script that is needed
cp src/build.disabled/post-compile.js src/build
# remove the bundled files and the dist directory
rm -rf src/build.disabled src/dist
# make a new clean dist directory
mkdir src/dist
# also remove the "site" directory, as it contains a bunch of bundled libs
rm -rf site



%build
pushd src
# I know this seems silly, as the makefile just copies the file from
# src/ to src/dist/, but it might do more in the future
make project
# Manually minify and post-process the file, as the Makefile is hardcoded to
# the bundled version of uglify-js
%{_bindir}/uglifyjs dist/jsonselect.js > dist/jsonselect.min.js.tmp
%__nodejs build/post-compile.js dist/jsonselect.min.js.tmp > dist/jsonselect.min.js
popd
# Now create a new "src" directory with only the built results, and without all the tests
mv src src.complete
mkdir src
cp src.complete/dist/*.js src/

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json src/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%__nodejs src.complete/test/run.js
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}



%changelog
