Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename levn

# Set to 0 to bootstrap optionator as a dependency for LiveScript itself
%global bootstrap 1

# Tests disabled until we can bootstrap npm(livescript)
%global enable_tests 0

Name:		nodejs-levn
Version:	0.3.0
Release:	alt1_10
Summary:	Light ECMAScript Value Notation - human written, concise, typed

License:	MIT
URL:		https://github.com/gkz/levn
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source2:	src-%{version}.tar.bz2
Source10:	dl-tests.sh
# The package.json.ls file isn't in the tarball either
Source11:	https://raw.githubusercontent.com/gkz/%{packagename}/%{version}/package.json.ls


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(prelude-ls)
BuildRequires:	npm(type-check)
%if 0%{?enable_tests}
BuildRequires:	node-mocha
%endif
%if !0%{?bootstrap}
BuildRequires:	npm(LiveScript)
%endif
Source44: import.info

%description
Light ECMAScript (JavaScript) Value Notation - human written, concise, typed,
flexible


%prep
%setup -q -n package
# setup the tests and src
%setup -q -T -D -a 1 -n package
%setup -q -T -D -a 2 -n package
# package.json.ls
cp -p %{SOURCE11} .



%build
%if !0%{?bootstrap}
echo -e "\e[102m -=#=- Building from source -=#=- \e[0m"
# Build from source
#
# Clear the lib/ directory
rm -rf ./lib/
mkdir ./lib/
# Next, build package.json from package.json.ls
%{_bindir}/lsc --compile package.json.ls
# Next, compile the the lib/ directory from the src/ directory
%{_bindir}/lsc --output lib --bare --compile src/*.ls
# Last but not least, clean up behind ourselves and erase the node_modules/ directory
rm -rf ./node_modules/
%endif

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R dot --ui tdd --compilers ls:livescript
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}


%changelog
