Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename linefix
%global enable_tests 1

Name:		nodejs-linefix
Version:	0.1.1
Release:	alt2_20
Summary:	Recursively repair line endings

License:	MIT
URL:		https://github.com/jhoff/linefix
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
Source1:	https://raw.githubusercontent.com/jhoff/linefix/master/LICENSE.txt


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
Source44: import.info

%description
Recursively repair line endings


%prep
%setup -q -n package

cp -p %{SOURCE1} .

# fix script interpreter not to use env
sed -i '1!b;s/env node/node/' bin/fix.js

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json bin/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}/bin
install -p -D -m0755 bin/fix.js %{buildroot}%{nodejs_sitelib}/%{packagename}/bin/fix.js

mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/%{packagename}/bin/fix.js \
    %{buildroot}%{_bindir}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%if 0%{?enable_tests}
echo -e "\e[103m -=#=- No test suite -=#=- \e[0m"
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE.txt
%{nodejs_sitelib}/%{packagename}
%{_bindir}/linefix

%changelog
