Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nodejs-mapnik-reference
Version:        8.10.0
Release:        alt1_4
Summary:        Reference for Mapnik Styling Options

License:        Public Domain
URL:            https://github.com/mapnik/mapnik-reference
Source0:        https://github.com/mapnik/mapnik-reference/archive/v%{version}/mapnik-reference-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(mocha)
BuildRequires:  npm(glob)
BuildRequires:  npm(lodash)
BuildRequires:  npm(semver)
Source44: import.info

%description
Provides a parseable spec of what Mapnik can do - what main structures
it supports (like layers, styles, and symbolizers) and the properties
they can contain. It's useful for building parsers, tests, compilers, and
syntax highlighting/checking for languages


%prep
%setup -q -n mapnik-reference-%{version}

%nodejs_fixdep --dev --move lodash


%build
%nodejs_symlink_deps --build
%__nodejs generate.js


%install
mkdir -p %{buildroot}/%{nodejs_sitelib}/mapnik-reference
cp -pr package.json index.js %{buildroot}/%{nodejs_sitelib}/mapnik-reference
mkdir -p %{buildroot}/%{_datadir}/%{name}
for dir in 2.* 3.*
do
  cp -pr ${dir} %{buildroot}/%{_datadir}/%{name}
  ln -sf %{_datadir}/%{name}/${dir} %{buildroot}/%{nodejs_sitelib}/mapnik-reference
done
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/mocha/bin/mocha -R spec --timeout 50000


%files
%doc README.md CHANGELOG.md
%doc --no-dereference LICENSE.md 
%{nodejs_sitelib}/mapnik-reference
%{_datadir}/%{name}


%changelog
