Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename mime-db
%global enable_tests 1

Name:		nodejs-mime-db
Version:	1.26.0
Release:	alt1_8
Summary:	This is a database of all mime types

License:	MIT
URL:		https://github.com/jshttp/mime-db
Source0:	https://github.com/jshttp/mime-db/archive/v%{version}.tar.gz

BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif

Requires:	node
Source44: import.info

%description
This is a database of all mime types. It consists of a single, public JSON
file and does not include any logic, allowing it to remain as un-opinionated
as possible with an API. It aggregates data from the following sources:

 * http://www.iana.org/assignments/media-types/media-types.xhtml
 * http://svn.apache.org/repos/asf/httpd/httpd/trunk/docs/conf/mime.types
 * http://hg.nginx.org/nginx/raw-file/default/conf/mime.types


%prep
%setup -q -n %{packagename}-%{version}


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js db.json src/ scripts/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
/usr/bin/mocha -R spec
%endif


%files
%{!?_licensedir:%global license %doc}
%doc README.md HISTORY.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}


%changelog
