# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# tests have circular dependency (mocha -> jade -> monocle)
%global enable_tests 0

Name:       nodejs-monocle
Version:    1.1.51
Release:    alt1_12
Summary:    A tool for watching directories for file changes
License:    BSD
Group:      System/Libraries
URL:        https://github.com/samccone/monocle
Source0:    https://registry.npmjs.org/monocle/-/monocle-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-00ccc2a0454058f0cd1964d0703d8322f78af049.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
BuildRequires:  npm(readdirp)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
find . -type f -exec chmod -x '{}' \;
%setup -q -T -D -a 1 -n package

%nodejs_fixdep readdirp '2.x'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/monocle
cp -pr package.json monocle.js \
    %{buildroot}%{nodejs_sitelib}/monocle

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
/usr/bin/mocha test -R spec -t 60000
%endif


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/monocle


%changelog
