Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:           nodejs-ms
Version:        2.0.0
Release:        alt1_7
Summary:        Tiny milliseconds conversion utility for Node.js

License:        MIT
URL:            https://www.npmjs.com/package/ms
Source0:        https://github.com/zeit/ms/archive/%{version}/%{name}-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(expect.js)
BuildRequires:  npm(mocha)
%endif
Source44: import.info

%description
This module is a tiny milliseconds conversion utility for Node.js.

It does the following:
 - If a number is supplied to ms, a string with a unit is returned.
 - If a string that contains the number is supplied, it returns it as a
   number (e.g: it returns 100 for '100').
 - If you pass a string with a number and a valid unit, the number of
   equivalent milliseconds is returned.


%prep
%setup -q -n ms-%{version}



%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/ms
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/ms

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/mocha/bin/mocha tests.js
%endif


%files
%doc readme.md
%doc --no-dereference license.md
%{nodejs_sitelib}/ms


%changelog
