Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename multipipe
%global enable_tests 1

Name:		nodejs-multipipe
Version:	1.0.2
Release:	alt1_6
Summary:	Pipe streams with centralized error handling

License:	MIT
URL:		https://github.com/juliangruber/multipipe.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(duplexer2)
BuildRequires:	npm(object-assign)
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(through2)
%endif
Source44: import.info

%description
Pipe streams with centralized error handling.


%prep
%setup -q -n package

# create license file from the Readme.md file

sed '0,/^## License/d' Readme.md > LICENSE.md

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"

%endif


%files
%{!?_licensedir:%global license %doc}
%doc Readme.md History.md
%doc --no-dereference LICENSE.md
%{nodejs_sitelib}/%{packagename}


%changelog
