Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0
# tests failing

Name:       nodejs-ncp
Version:    2.0.0
Release:    alt1_8
Summary:    Asynchronous recursive file copy utility for Node.js
License:    MIT
URL:        https://github.com/AvianFlu/ncp
Source0:    http://registry.npmjs.org/ncp/-/ncp-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(deep-equal)
BuildRequires:  npm(mocha)
BuildRequires:  npm(read-dir-files)
BuildRequires:  npm(rimraf)
%endif
Source44: import.info

%description
This module is an asynchronous recursive copy utility for Node.js.
Think cp -r, but pure node, and asynchronous. ncp can be used both
as a CLI tool and programmatically.


%prep
%setup -q -n package

# fix interpreter
sed -i '1s/env //' bin/ncp

%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/ncp
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/ncp
mkdir -p %{buildroot}%{nodejs_sitelib}/ncp/bin
install -p -D -m0755 bin/ncp %{buildroot}%{nodejs_sitelib}/ncp/bin/ncp
mkdir -p %{buildroot}%{_bindir}
ln -s %{nodejs_sitelib}/ncp/bin/ncp %{buildroot}%{_bindir}/ncp

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif



%files
%{!?_licensedir:%global license %doc}
%doc README.md
%doc --no-dereference LICENSE.md
%{nodejs_sitelib}/ncp
%{_bindir}/ncp


%changelog
